-- Load in config options
local forest_tasks = {
	["Befriend the pigs"]		= GetModConfigData("BEFRIENDTHEPIGS")		or "RANDOM",
	["For a nice walk"]			= GetModConfigData("FORANICEWALK")			or "RANDOM",
	["Kill the spiders"]		= GetModConfigData("KILLTHESPIDERS")		or "RANDOM",
	["Killer Bees!"]			= GetModConfigData("KILLERBEES")			or "RANDOM",
	["Make A Beehat"]			= GetModConfigData("MAKEABEEHAT")			or "RANDOM",
	["The hunters"]				= GetModConfigData("THEHUNTERS")			or "RANDOM",
	["Magic meadow"]			= GetModConfigData("MAGICMEADOW")			or "RANDOM",
	["Frogs and bugs"]			= GetModConfigData("FROGSANDBUGS")			or "RANDOM"
}

local rog_tasks = {
	["Oasis"]					= GetModConfigData("OASIS")					or "RANDOM",
	["Mole Colony Deciduous"]	= GetModConfigData("MOLECOLONYDECIDUOUS")	or "RANDOM",
	["Mole Colony Rocks"]		= GetModConfigData("MOLECOLONYROCKS")		or "RANDOM"
}
	
local cave_tasks = {
	["CaveBase"]				= GetModConfigData("CAVEBASE")				or "RANDOM",
	["MushBase"]				= GetModConfigData("MUSHBASE")				or "RANDOM",
	["SinkBase"]				= GetModConfigData("SINKBASE")				or "RANDOM",
	["RabbitTown"]				= GetModConfigData("RABBITTOWN")			or "RANDOM",
	["RedFungalComplex"]		= GetModConfigData("REDFUNGALCOMPLEX")		or "RANDOM",
	["GreenFungalComplex"]		= GetModConfigData("GREENFUNGALCOMPLEX")	or "RANDOM",
	["BlueFungalComplex"]		= GetModConfigData("BLUEFUNGALCOMPLEX")		or "RANDOM"
}

local ruins_tasks = {
	["MoreAltars"]				= GetModConfigData("MOREALTARS")			or "RANDOM",
	["SacredDanger"]			= GetModConfigData("SACREDDANGER")			or "RANDOM",
	["FailedCamp"]				= GetModConfigData("FAILEDCAMP")			or "RANDOM",
	["Residential2"]			= GetModConfigData("RESIDENTIAL2")			or "RANDOM",
	["Residential3"]			= GetModConfigData("RESIDENTIAL3")			or "RANDOM",
	["Military2"]				= GetModConfigData("MILITARY2")				or "RANDOM",
	["Sacred2"]					= GetModConfigData("SACRED2")				or "RANDOM"
}

local function ForceBiome(level)
	-- Workaround for RoG enabled but Shipwrecked Compatible
	local json = GLOBAL.require("json")
	local parameters = json.decode(GLOBAL.GEN_PARAMETERS or {})
	local ROG = parameters.ROGEnabled or false
	--DLC
	local RoGEnabled = GLOBAL.IsDLCEnabled and GLOBAL.REIGN_OF_GIANTS and GLOBAL.IsDLCEnabled(GLOBAL.REIGN_OF_GIANTS) or false
	-- setup optional tasks based on forest or caves
	local optional_tasks = {}
	if level.id == "SURVIVAL_DEFAULT" then
		if RoGEnabled or ROG then
			print("Force Biome: RoG Enabled")
			for task,add in pairs(rog_tasks) do
				forest_tasks[task] = add
			end
		end
		optional_tasks = forest_tasks
		print("Force Biome: Adding forest biomes...")
	elseif level.id == "CAVE_LEVEL_1" then
		optional_tasks = cave_tasks
		print("Force Biome: Adding cave biomes...")
	elseif level.id == "CAVE_LEVEL_2" then
		optional_tasks = ruins_tasks
		print("Force Biome: Adding ruins biomes...")
	else
		print("Force Biome: level: " .. tostring(level.id) .. " is not supported")
		return
	end
	-- populate biomes that you want to add into main task table
	local task_size = table.getn(level.tasks)
	local count = 0
	for task,add in pairs(optional_tasks) do
		if add == "ON" then
			table.insert(level.tasks, task)
			count = count + 1
			print("Force Biome: Adding " .. tostring(task) .. " to main tasks")
		elseif add == "OFF" then
			for index,optional in pairs(level.optionaltasks) do
				if optional:lower() == task:lower() then
					table.remove(level.optionaltasks, index)
					print("Force Biome: Removing " .. tostring(task) .. " from optionaltasks")
				end
			end
		end
	end
	-- remove duplicates
	for i=task_size+1,task_size+count do
		for index,task in pairs(level.tasks) do
			if level.tasks[i]:lower() == task:lower() then
				if i ~= index then
					table.remove(level.tasks, index)
					print("Force Biome: Removing " .. tostring(task) .. " from main tasks")
				end
				break
			end
		end
		for index,task in pairs(level.optionaltasks) do
			if level.tasks[i]:lower() == task:lower() then
				table.remove(level.optionaltasks, index)
				level.numoptionaltasks = level.numoptionaltasks - 1  -- dont care if less than 0, there is check in base code
				print("Force Biome: Removing " .. tostring(task) .. " from optionaltasks (already in main task!)")
				break
			end
		end
	end
	print("Force Biome: Finished adding biomes!")	
end

AddLevelPreInitAny(ForceBiome)